// Controls header shrinking
function scroll()
{
  var shrinkY = 100;
	var subShrinkY = 200;
	var positionY = window.pageYOffset || document.documentElement.scrollTop;
	var up = false;

  var info = document.querySelector("#site-header #info");
  var menu = document.querySelector("#site-header #menu");
  var submenu = document.querySelector("#site-header #submenu");
	
	if(submenu){
		$('main').css('padding-top', function (index, curValue) {
			return parseInt(curValue, 10) + 40 + 'px';
		});
	}

	// Normal header shrinking
  function toggleShrink() {
    var newposY = window.pageYOffset || document.documentElement.scrollTop;
		
		if(newposY > shrinkY){
			info.classList.add("shrink");
			menu.classList.add("shrink");
		}else if(info.classList.contains("shrink")){
			info.classList.remove("shrink");
			menu.classList.remove("shrink");
		}
		// Submenu shrinking
		if(submenu){
			if(newposY > subShrinkY && (newposY > positionY && !up)){
				submenu.classList.add("shrink");
				up = !up;
			}else if(submenu.classList.contains("shrink") && (newposY < subShrinkY || (newposY < positionY && up))){
				submenu.classList.remove("shrink");
				up = !up;
			}
			positionY = newposY;
		}
  };
	
	// Feature page header
	function featureShrink() {
		var newposY = window.pageYOffset || document.documentElement.scrollTop;
		
		if(newposY > shrinkY){
			info.classList.remove("shrink");
			menu.classList.remove("hide");
		}else if(!info.classList.contains("shrink")){
			info.classList.add("shrink");
			menu.classList.add("hide");
		}
	}
	// Feature page arrow button
	function featureArrowScroll() {
		$('html,body').animate({
        scrollTop: $(".overlay").outerHeight()-50},
        1000);
	}
	
	if(document.querySelector(".feature-post")){
		shrinkY = $(window).height()-51;
		featureShrink();
		window.addEventListener('scroll', featureShrink);				
		document.querySelector(".bounce.animated").addEventListener('click', featureArrowScroll);				
	}else{
		toggleShrink();
		window.addEventListener('scroll', toggleShrink);		
	}
};

// Controls search-bar animations and stuff
function search()
{
	$("#search").click(function(){
		$(this).css("pointer-events", "none");
		$("#search-bar").focus();
		setTimeout(function(){
			$("#search").css("pointer-events", "auto");
		}, 250);
	});
	
	$("#search-bar").focusin(function(){
			$("#site-header #menu nav > a").addClass("hide");
			setTimeout(function(){
				$("#site-header #menu nav > a").addClass("no-display");
			}, 250);
	});
	
	$("#search-bar").focusout(function(){
			$("#site-header #menu nav > a").removeClass("no-display");
			$("#site-header #menu nav > a").removeClass("hide");
	});
};

// Mobile submenu draggability
function submenu()
{
	var menuWidth = $("#submenu").outerWidth();
	var navWidth = $("#submenu nav div").outerWidth();

	$("#submenu nav").css("width", navWidth);

	if(navWidth > menuWidth){
		$("#submenu").addClass("grabbable");
		$("#submenu nav").draggable({
			axis: 'x',
			drag: function (event, ui) {
				if (ui.position.left > (navWidth - menuWidth)) ui.position.left = navWidth - menuWidth;
				if (ui.position.left < 0) ui.position.left = 0;
			}
		});
	}else{
		$("#submenu").removeClass("grabbable");
	}
};

// Controls mobile menu
function burger()
{
	$("#burger").click(function(){
		if($(this).hasClass("open")){
			$(this).removeClass("open");
			$("#mobile-menu").removeClass("open");

			setTimeout(function(){
				$("#menu").css("box-shadow","none");
			}, 250);
			
			$("body").removeClass("noscroll");
			$('body').unbind('touchmove');
		}else{
			$(this).addClass("open");
			$("#mobile-menu").addClass("open");
			
			$("#menu").css("box-shadow","0px 2px 4px 0px rgba(0,0,0,0.50)")
			
			$("body").addClass("noscroll");
			$('body').bind('touchmove', function(e) {
				e.preventDefault()
			});
		}
	});
}

// Carousel slider settings
function flick()
{
	var carousel = $('.gallery.js-flickity').flickity();
	
	// Pauses autoplay when window loses focus
	window.addEventListener('blur', function() {
		carousel.flickity('pausePlayer');
	}, false);
	window.addEventListener('focus', function() {
		carousel.flickity('unpausePlayer');
	}, false);

}

// Initialize a perfundo lightbox
function lightbox()
{
	var lightbox = document.querySelector(".perfundo");
	if(lightbox){
		var myLightbox = new perfundo('.perfundo', {
			disableHistory: true,
			swipe: true
		});
	}
}

function init()
{
	scroll();
	search();
	burger();
	submenu();
	flick();
	lightbox();
}

window.onload = init;