<?php

/*
	Plugin Name: Pipe Dream Zones
	Contributors: Daniel O'Connor
	Tags: section, query, zone
	Requires at least: 3.3.1
	Tested up to: 3.5.1
	Version: 1.0
*/

/*
 *	Grab the most importants posts in each
 *  category to display in a nice layout.
 *
 *  The function also checks to see if any
 *  of the posts in the feature-feature or
 *  feature-list since those take precidence.
*/

function pd_get_featured_posts($category_id) {
	
    $posts = array();
    $zones = array();
    $category_name = get_category($category_id)->slug;
    
    $zones[] = z_get_posts_in_zone('zone-' . $category_name);
    $zones[] = z_get_posts_in_zone('zone-above-the-fold-with-thumbnail');
    $zones[] = z_get_posts_in_zone('zone-above-the-fold-no-thumbnail');
    foreach($zones as $zone) {
        foreach($zone as $post) {
            $categories = get_the_category($post);
            foreach( $categories as $category) {
                if($category->term_id === $category_id ) {
                    $article = objectToArray($post);
                    $posts[] = $article['ID'];
                    
                }
            }
        }
    }
    
    $posts = array_unique($posts);

    
    
    return $posts;

}
